﻿var popUpDistributionWizard = {
    context: $(".v-popupWizard"),
    initialize: function () {
        $(".page:not(:first)", this.context).hide();
    },
    bindEvents: function () {
        var self = this;
        var context = this.context;

        context.on("change", "#Type", function () {
            var isLink = $(this).val() == "Link";
            $("#Frequency", context).prop("disabled", isLink);
            $("#CancelText", context).prop("disabled", isLink);
        });
    },
    updatePage: function (page) {
        var pageIndex = page.attr("data-index");
        var context = this.context;

        if (pageIndex == 2) {
            $("#Text").a4richTextEditor({ library: true, readonly: true });
        }
        if (pageIndex == 3) {
            var preview = $(".distribution-preview", context);

            $(".preview-frequency", context).text($("#Frequency", context).val());
            $(".popup-content", preview).html(a4.decodeHtml($("#Text", context).a4richTextEditor("getContent")));
            $(".close", preview).text($("#CancelText", context).val());
            $(".link", preview).text($("#LinkText", context).val());

            var popUpType = $("#Type option:selected", context).val();
            $("> div", preview).hide();

            switch (popUpType) {
                case "Dialog":
                    $(".dialog", preview).show();
                    break;
                case "NotificationBarTop":
                    $(".notification-bar-top", preview).show();
                    break;
                case "NotificationBarBottom":
                    $(".notification-bar-bottom", preview).show();
                    break;
                default:
                    $(".link-only", preview).show();
            }
        }
    }
}

$(document).ready(function () {
    if (popUpDistributionWizard.context.length > 0) {
        popUpDistributionWizard.initialize();
        popUpDistributionWizard.bindEvents();
        distributionWizard.initializeBase(popUpDistributionWizard);
        distributionWizard.bindBaseEvents(popUpDistributionWizard);
    }
});